IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  name='SF_BancoPatagonia_TX') 
BEGIN
    DROP FUNCTION [dbo].[SF_BancoPatagonia_TX] 
END
GO

CREATE FUNCTION [dbo].[SF_BancoPatagonia_TX](@pId_Trans INT, @pTarNro VARCHAR(22), @pFecha_Venc DATETIME) 
RETURNS CHAR(200)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			CHAR(200)
/*FIN Variable de Retorno*/

/*Variables del Archivo*/
/*Para todos los tipos de novedad*/
DECLARE @aTipoNovedad				CHAR(1)		/*Tipo de Novedad / D - Debitos*/
DECLARE @aCUIT						CHAR(11)	/*CUIT/L DNI del Cliente*/
/*Bloque 1 de la CBU*/
DECLARE @aEntidad					CHAR(3)		/*Entidad*/
DECLARE @aSucursal					CHAR(4)		/*Sucursal*/
DECLARE @aDigVerifBloq1				CHAR(1)		/*Digito Verificador Bloque 1*/
/*Bloque 2 de la CBU*/
DECLARE @aTipoCuenta				CHAR(2)		/*Tipo de Cuenta*/
DECLARE @aNroCuenta					CHAR(11)	/*Nro. de Cuenta*/
DECLARE @aDigVerifBloq2				CHAR(1)		/*Digito Verificador Bloque 2*/
/*Segun tabla COELSA - ACH*/
DECLARE @aIdentClientePag			CHAR(22)	/*Identificador Cliente Pagador*/
DECLARE @aFechaVenc					CHAR(8)		/*Fecha de Vencimiento*/
DECLARE @aProdPrestacion			CHAR(10)	/*Producto/Prestacion*/
/*Para Adhesiones*/
DECLARE @aADHTipoDoc				CHAR(4)		/*Tipo de Documento*/
DECLARE @aADHNroDoc					CHAR(11)	/*Nro. de Documento*/
/*Para Dbitos, Reversiones*/
DECLARE @aDEBRefDeb					CHAR(15)	/*Referencia del dbito*/
DECLARE @aDEBImporte				CHAR(10)	/*Importe (8 enteros y 2 decimales)*/
DECLARE @aDEBTipoMon				CHAR(1)		/*Tipo de Moneda./ P:Pesos o D:Dolares*/
/*Para notificaciones de Cambio en Empresa Originante*/
DECLARE @aNOTEMPORIIdentCliPag		CHAR(22)	/*Identificador de Cliente Nuevo*/
/*Para Notificaciones de Cambio en Entidad Receptoras*/
/*Bloque 2 de la CBU*/
DECLARE @aNOTENTRECEPTipoCuenta		CHAR(2)		/*Tipo de Cuenta*/
DECLARE @aNOTENTRECEPNroCuenta		CHAR(11)	/*Nro de Cuenta*/
DECLARE @aNOTENTRECEPDigVerifBloq2	CHAR(1)		/*Digito Verificador - Bloque 2*/
/*Para Rechazos en la rendicion, en las presentaciones dajar en blanco*/
DECLARE @aRECHCodRechazo			CHAR(3)		/*Codigo de Rechazo. Ej R02, R03,...*/
DECLARE @aOBLIGReserv				CHAR(35)	/*Reserva. (Blancos)*/
DECLARE @aOBLIGNroCuitEmp			CHAR(11)	/*Nro. Cuit Empresa.*/
/*FIN Variables del Archivo*/

/*Variables Intermedias*/
DECLARE @Importe						VARCHAR(10)
DECLARE @FechaVencimiento				DATETIME
DECLARE @Id_Cliente						INT
DECLARE @CBU							VARCHAR(25)
DECLARE @CBU_PrimerBloque_IdBanco		CHAR(3)
DECLARE @CBU_PrimerBloque_IdSuc			CHAR(4)
DECLARE @CBU_PrimerBloque_DigVerifPriBlo CHAR(1)
DECLARE @CBU_SegundBloque_TipoCuenta	CHAR(2)
DECLARE @CBU_SegundBloque_NroCuenta		CHAR(11)
DECLARE @CBU_SegundBloque_DigVerifC		CHAR(1)
/*FIN Variables Intermedias*/

/*Calculo CBU*/
SET @CBU				= @pTarNro

SET @CBU_PrimerBloque_IdBanco			= (SELECT CAST(SUBSTRING(@CBU,1,3) AS CHAR(3)))
SET @CBU_PrimerBloque_IdSuc				= (SELECT CAST(SUBSTRING(@CBU,4,4) AS CHAR(4)))
SET @CBU_PrimerBloque_DigVerifPriBlo	= (SELECT CAST(SUBSTRING(@CBU,8,1) AS CHAR(1)))

SET @CBU_SegundBloque_TipoCuenta		= (SELECT CAST(SUBSTRING(@CBU,9,2) AS CHAR(2)))
SET @CBU_SegundBloque_NroCuenta			= (SELECT CAST(SUBSTRING(@CBU,11,11) AS CHAR(11)))
SET @CBU_SegundBloque_DigVerifC			= (SELECT CAST(SUBSTRING(@CBU,22,1) AS CHAR(1)))
/*FIN Calculo CBU*/

SET @Id_Cliente			= (SELECT ISNULL(Id_Cliente,0)			FROM Cbtes WHERE Id_Trans = @pId_Trans)
--5/12/2018 Se toma fecha del Lote en vez del Cbte por Ticket 15.404
SET @FechaVencimiento	= ISNULL(@pFecha_Venc, DATEADD(dd, 10, GETDATE()))
SET @Importe			= (SELECT RIGHT( '0000000000' + CAST(CAST((ISNULL(Saldo/*Imp_Total*/,0) + ISNULL(Saldo_Anterior,0)) * Cotizacion * 100 AS INT) AS VARCHAR), 10) 
						   FROM Cbtes WHERE Id_Trans = @pId_Trans)

/*Grabacion de los campos de la fila*/
SET @aTipoNovedad				= 'D'
SET @aCUIT						= '00000000000'
SET @aEntidad					= @CBU_PrimerBloque_IdBanco
SET @aSucursal					= @CBU_PrimerBloque_IdSuc
SET @aDigVerifBloq1				= @CBU_PrimerBloque_DigVerifPriBlo
SET @aTipoCuenta				= @CBU_SegundBloque_TipoCuenta
SET @aNroCuenta					= @CBU_SegundBloque_NroCuenta
SET @aDigVerifBloq2				= @CBU_SegundBloque_DigVerifC
SET @aIdentClientePag			= ISNULL(LEFT(CAST(RIGHT('000000' + CONVERT(VARCHAR(10), @Id_Cliente), 6) AS VARCHAR) + '                      ', 22), '                      ')
SET @aFechaVenc					= /*DD*/RIGHT('00' + CAST(DATEPART(dd, @FechaVencimiento) AS VARCHAR),2) + /*MM*/RIGHT('00' + CAST(DATEPART(mm, @FechaVencimiento) AS VARCHAR),2) + /*AAAA*/CAST(DATEPART(YY, @FechaVencimiento) AS CHAR(4))
SET @aProdPrestacion			= 'CUOTAS    '
SET @aADHTipoDoc				= '    '
SET @aADHNroDoc					= '00000000000'
SET @aDEBRefDeb					= ISNULL(LEFT(CAST(@pId_Trans AS VARCHAR) + '               ', 15), '               ')
SET @aDEBImporte				= @Importe
SET @aDEBTipoMon				= 'P'
SET @aNOTEMPORIIdentCliPag		= '                      '
SET @aNOTENTRECEPTipoCuenta		= '00'
SET @aNOTENTRECEPNroCuenta		= '00000000000'
SET @aNOTENTRECEPDigVerifBloq2	= '0'
SET @aRECHCodRechazo			= '   '
SET @aOBLIGReserv				= '                                   '
SET @aOBLIGNroCuitEmp			= (dbo.CF_XParam('RECE_Cuit'))

/*FIN Grabacion de los campos de la fila*/

/*Grabacion de la Fila Completa*/
SET @Retorno			=	@aTipoNovedad				+ @aCUIT						+ @aEntidad +
							@aSucursal					+ @aDigVerifBloq1				+ @aTipoCuenta +
							@aNroCuenta					+ @aDigVerifBloq2				+ @aIdentClientePag +
							@aFechaVenc					+ @aProdPrestacion				+ @aADHTipoDoc +
							@aADHNroDoc					+ @aDEBRefDeb					+ @aDEBImporte + 
							@aDEBTipoMon				+ @aNOTEMPORIIdentCliPag		+ @aNOTENTRECEPTipoCuenta +
							@aNOTENTRECEPNroCuenta		+ @aNOTENTRECEPDigVerifBloq2	+ @aRECHCodRechazo +
							@aOBLIGReserv				+ @aOBLIGNroCuitEmp
/*FIN Grabacion de la Fila Completa*/

RETURN @retorno
END
